<?php
// 設定ファイルのサンプル
// このファイルをconfig.phpという名前でコピーして使用してください

$config = [
    // APIキー
    'api_keys' => [
        'openai' => '',        // OpenAI API Key (GPT-4等で使用)
        'claude' => '',        // Anthropic API Key (Claude用)
        'gemini' => '',        // Google API Key (Gemini用)
        'perplexity' => '',    // Perplexity API Key (オプション)
        'venice' => ''         // Venice AI API Key (オプション)
    ],
    
    // DMM設定
    'dmm' => [
        'api_id' => '',        // DMM API ID
        'affiliate_id' => ''   // DMMアフィリエイトID
    ],
    
    // 管理画面設定
    'admin_password' => 'admin', // 管理画面のパスワード（必ず変更してください！）
    'session_timeout' => 86400, // セッションタイムアウト（秒）: 24時間
    
    // FTPプロファイル
    'ftp_profiles' => []
];

require_once __DIR__ . '/config.default.php';
// array_mergeは後の配列が前の配列を上書きするため、$configを後にする必要がある
$config = array_merge($defaultConfig, $config);

return $config;
?>