/**
 * Select2でカテゴリ選択を改善
 */
$(document).ready(function() {
    // すべてのカテゴリ選択要素にSelect2を適用
    function initializeSelect2() {
        $('select[name="category"], select#categoryFilter').each(function() {
            if (!$(this).hasClass('select2-hidden-accessible')) {
                $(this).select2({
                    theme: 'bootstrap-5',
                    width: '100%',
                    placeholder: 'カテゴリを選択または入力...',
                    allowClear: true,
                    tags: true, // 新しいカテゴリの入力を許可
                    language: {
                        searching: function() {
                            return '検索中...';
                        },
                        noResults: function() {
                            return '見つかりません';
                        },
                        inputTooShort: function() {
                            return '文字を入力してください';
                        },
                        errorLoading: function() {
                            return '結果を読み込めません';
                        }
                    }
                });
            }
        });
    }
    
    // 初回実行
    initializeSelect2();
    
    // モーダルが開いた時にも実行
    $(document).on('shown.bs.modal', function() {
        setTimeout(initializeSelect2, 100);
    });
    
    // タブが切り替わった時にも実行
    $(document).on('shown.bs.tab', function() {
        setTimeout(initializeSelect2, 100);
    });
    
    // AJAXリクエスト完了後にも実行
    $(document).ajaxComplete(function() {
        setTimeout(initializeSelect2, 100);
    });
});