<?php
// プリセットの読み込み
$presetsFile = __DIR__ . '/../../data/presets.json';
$presets = [];
if (file_exists($presetsFile)) {
    $presets = json_decode(file_get_contents($presetsFile), true) ?: [];
}

// 自動生成処理（新しいタブから）
$autoGenerateScript = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['auto_generate'])) {
    $autoGenerateScript = '
    <script>
    window.addEventListener("DOMContentLoaded", function() {
        console.log("Auto-generating article from new tab...");
        
        // POSTデータをフォームに設定
        ' . (isset($_POST['title']) ? 'document.getElementById("title").value = ' . json_encode($_POST['title']) . ';' : '') . '
        ' . (isset($_POST['keywords']) ? 'document.getElementById("keywords").value = ' . json_encode($_POST['keywords']) . ';' : '') . '
        ' . (isset($_POST['model']) ? 'document.getElementById("model").value = ' . json_encode($_POST['model']) . ';' : '') . '
        ' . (isset($_POST['user_prompt']) ? 'document.getElementById("user_prompt").value = ' . json_encode($_POST['user_prompt']) . ';' : '') . '
        ' . (isset($_POST['temperature']) ? 'document.getElementById("temperature").value = ' . json_encode($_POST['temperature']) . '; document.getElementById("temperatureValue").textContent = ' . json_encode($_POST['temperature']) . ';' : '') . '
        ' . (isset($_POST['max_tokens']) ? 'document.getElementById("max_tokens").value = ' . json_encode($_POST['max_tokens']) . ';' : '') . '
        ' . (isset($_POST['save_history']) ? 'document.getElementById("save_history").checked = ' . ($_POST['save_history'] ? 'true' : 'false') . ';' : '') . '
        
        // 少し待ってから送信
        setTimeout(function() {
            document.getElementById("generateBtn").click();
        }, 500);
    });
    </script>
    ';
}
?>

<div class="page-header">
    <h1><i class="bi bi-file-text"></i> 記事生成</h1>
    <p class="text-muted">AIを使用して高品質な記事を生成します</p>
</div>

<div class="row">
    <div class="col-md-8">
        <div class="card">
            <div class="card-body">
                <form id="generateForm" method="POST">
                    <!-- 基本設定 -->
                    <div class="mb-4">
                        <label for="title" class="form-label">記事タイトル</label>
                        <input type="text" class="form-control" id="title" name="title"
                               placeholder="例：AIの最新トレンド2025" required>
                    </div>
                    
                    <div class="mb-4">
                        <label for="keywords" class="form-label">キーワード</label>
                        <input type="text" class="form-control" id="keywords" name="keywords"
                               placeholder="カンマ区切りで入力（例：AI, 人工知能, 機械学習）">
                    </div>
                    
                    <div class="row mb-4">
                        <div class="col-md-6">
                            <label for="model" class="form-label">AIモデル</label>
                            <select class="form-control" id="model" name="model">
                                <?php foreach ($config['models'] as $provider => $models): ?>
                                    <optgroup label="<?php echo ucfirst($provider); ?>">
                                        <?php foreach ($models as $key => $model): ?>
                                            <option value="<?php echo htmlspecialchars($key); ?>" 
                                                    <?php echo $key === $config['default_model'] ? 'selected' : ''; ?>>
                                                <?php echo htmlspecialchars($model['name']); ?>
                                            </option>
                                        <?php endforeach; ?>
                                    </optgroup>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        <div class="col-md-6">
                            <label for="output_format" class="form-label">出力形式</label>
                            <select class="form-control" id="output_format" name="output_format">
                                <option value="visual">ビジュアルエディタ</option>
                                <option value="html">HTML</option>
                                <option value="markdown">Markdown</option>
                                <option value="text">プレーンテキスト</option>
                            </select>
                        </div>
                    </div>
                    
                    <!-- Temperature設定 -->
                    <div class="row mb-4">
                        <div class="col-md-6">
                            <label for="temperature" class="form-label">
                                Temperature 
                                <span class="text-muted">(<span id="temperatureValue">0.7</span>)</span>
                            </label>
                            <input type="range" class="form-range" id="temperature" name="temperature"
                                   min="0" max="1" step="0.1" value="0.7"
                                   oninput="document.getElementById('temperatureValue').textContent = this.value">
                        </div>
                        <div class="col-md-6">
                            <label for="max_tokens" class="form-label">最大トークン数</label>
                            <input type="number" class="form-control" id="max_tokens" name="max_tokens"
                                   value="2000" min="100">
                        </div>
                    </div>
                    
                    <!-- ユーザープロンプト -->
                    <div class="mb-4">
                        <label for="user_prompt" class="form-label">記事の内容（プロンプト）</label>
                        <textarea class="form-control" id="user_prompt" name="user_prompt" rows="5" required
                                  placeholder="生成したい記事の内容を詳しく説明してください。"></textarea>
                    </div>
                    
                    <div class="mb-3">
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" id="save_history" name="save_history" checked>
                            <label class="form-check-label" for="save_history">
                                履歴に保存
                            </label>
                        </div>
                    </div>
                    
                    <div class="d-flex gap-2 align-items-center">
                        <button type="submit" class="btn btn-primary btn-lg" id="generateBtn">
                            <i class="bi bi-magic"></i> 記事を生成
                        </button>
                        <button type="button" class="btn btn-outline-primary btn-lg" 
                                onclick="generateInNewTab()"
                                title="新しいタブで生成（複数同時生成可能）">
                            <i class="bi bi-box-arrow-up-right"></i> 新しいタブで生成
                        </button>
                    </div>
                </form>
            </div>
        </div>
        
        <!-- 結果表示エリア -->
        <div id="resultArea" class="mt-4" style="display: none;">
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0">生成結果</h5>
                </div>
                <div class="card-body" id="resultContent">
                    <!-- 結果がここに表示される -->
                </div>
            </div>
        </div>
    </div>
</div>

<script>
// グローバル変数
let currentArticle = null;

// フォーム送信処理
document.addEventListener('DOMContentLoaded', function() {
    const form = document.getElementById('generateForm');
    
    form.addEventListener('submit', async (e) => {
        e.preventDefault();
        
        const btn = document.getElementById('generateBtn');
        const originalText = btn.innerHTML;
        btn.disabled = true;
        btn.innerHTML = '<span class="spinner-border spinner-border-sm me-2"></span>生成中...';
        
        try {
            const formData = {
                action: 'generate',
                title: document.getElementById('title').value,
                keywords: document.getElementById('keywords').value,
                model: document.getElementById('model').value,
                output_format: document.getElementById('output_format').value,
                user_prompt: document.getElementById('user_prompt').value,
                temperature: parseFloat(document.getElementById('temperature').value),
                max_tokens: parseInt(document.getElementById('max_tokens').value),
                save_history: document.getElementById('save_history').checked,
                enable_perplexity: false,
                enable_images: false
            };
            
            const response = await fetch('../api/service.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json; charset=utf-8'
                },
                credentials: 'same-origin',
                body: JSON.stringify(formData)
            });
            
            const responseText = await response.text();
            
            let result;
            try {
                result = JSON.parse(responseText);
            } catch (e) {
                console.error('JSON Parse Error:', e);
                console.error('Response Text:', responseText);
                
                if (responseText.includes('<!DOCTYPE') || responseText.includes('<html')) {
                    throw new Error('サーバーエラー: HTMLレスポンスが返されました。');
                } else {
                    throw new Error('サーバーエラー: 不正なレスポンス');
                }
            }
            
            if (result.success) {
                currentArticle = result.content;
                document.getElementById('resultArea').style.display = 'block';
                document.getElementById('resultContent').innerHTML = result.content;
                
                // 成功メッセージを表示
                showToast('記事生成が完了しました！', 'success');
            } else {
                alert('エラー: ' + result.error);
            }
            
        } catch (error) {
            alert('通信エラーが発生しました: ' + error.message);
        } finally {
            btn.disabled = false;
            btn.innerHTML = originalText;
        }
    });
});

// 新しいタブで生成する関数
function generateInNewTab() {
    const form = document.getElementById('generateForm');
    
    // フォームのバリデーションチェック
    if (!form.checkValidity()) {
        form.reportValidity();
        return;
    }
    
    // 新しいフォームを作成して新しいタブに送信
    const newForm = document.createElement('form');
    newForm.method = 'POST';
    newForm.action = window.location.href;
    newForm.target = '_blank';
    
    // 現在のフォームの全ての入力要素をコピー
    const inputs = form.querySelectorAll('input, select, textarea');
    inputs.forEach(input => {
        const hiddenInput = document.createElement('input');
        hiddenInput.type = 'hidden';
        hiddenInput.name = input.name;
        
        if (input.type === 'checkbox') {
            hiddenInput.value = input.checked ? '1' : '0';
        } else {
            hiddenInput.value = input.value;
        }
        
        newForm.appendChild(hiddenInput);
    });
    
    // 自動実行フラグを追加
    const autoRunInput = document.createElement('input');
    autoRunInput.type = 'hidden';
    autoRunInput.name = 'auto_generate';
    autoRunInput.value = '1';
    newForm.appendChild(autoRunInput);
    
    // フォームを送信して削除
    document.body.appendChild(newForm);
    newForm.submit();
    document.body.removeChild(newForm);
}

// トースト表示関数
function showToast(message, type = 'info') {
    const toastHtml = `
        <div class="toast align-items-center text-white bg-${type} border-0" role="alert">
            <div class="d-flex">
                <div class="toast-body">${message}</div>
                <button type="button" class="btn-close btn-close-white me-2 m-auto" data-bs-dismiss="toast"></button>
            </div>
        </div>
    `;
    
    let container = document.querySelector('.toast-container');
    if (!container) {
        container = document.createElement('div');
        container.className = 'toast-container position-fixed top-0 end-0 p-3';
        container.style.zIndex = '9999';
        document.body.appendChild(container);
    }
    
    container.insertAdjacentHTML('beforeend', toastHtml);
    const toastEl = container.lastElementChild;
    const toast = new bootstrap.Toast(toastEl);
    toast.show();
    
    toastEl.addEventListener('hidden.bs.toast', () => {
        toastEl.remove();
    });
}
</script>

<?php echo $autoGenerateScript; ?>