<?php
// プリセットの読み込み
$presetsFile = __DIR__ . '/../../data/presets.json';
$presets = [];
if (file_exists($presetsFile)) {
    $presets = json_decode(file_get_contents($presetsFile), true) ?: [];
}
?>

<div class="page-header">
    <h1><i class="bi bi-file-text"></i> 記事生成</h1>
    <p class="text-muted">AIを使用して高品質な記事を生成します</p>
</div>

<div class="row">
    <div class="col-md-8">
        <div class="card">
            <div class="card-body">
                <form id="generateForm" method="POST">
                    <!-- 基本設定 -->
                    <div class="mb-4">
                        <label for="title" class="form-label">記事タイトル</label>
                        <input type="text" class="form-control" id="title" name="title"
                               placeholder="例：AIの最新トレンド2025" required>
                    </div>
                    
                    <div class="mb-4">
                        <label for="keywords" class="form-label">キーワード</label>
                        <input type="text" class="form-control" id="keywords" name="keywords"
                               placeholder="カンマ区切りで入力（例：AI, 人工知能, 機械学習）">
                    </div>
                    
                    <div class="mb-4">
                        <label for="model" class="form-label">AIモデル</label>
                        <select class="form-control" id="model" name="model">
                            <?php foreach ($config['models'] as $provider => $models): ?>
                                <optgroup label="<?php echo ucfirst($provider); ?>">
                                    <?php foreach ($models as $key => $model): ?>
                                        <option value="<?php echo htmlspecialchars($key); ?>" 
                                                <?php echo $key === $config['default_model'] ? 'selected' : ''; ?>>
                                            <?php echo htmlspecialchars($model['name']); ?>
                                        </option>
                                    <?php endforeach; ?>
                                </optgroup>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    
                    <!-- ユーザープロンプト -->
                    <div class="mb-4">
                        <label for="user_prompt" class="form-label">記事の内容（プロンプト）</label>
                        <textarea class="form-control" id="user_prompt" name="user_prompt" rows="5" required
                                  placeholder="生成したい記事の内容を詳しく説明してください。"></textarea>
                    </div>
                    
                    <button type="submit" class="btn btn-primary btn-lg" id="generateBtn">
                        <i class="bi bi-magic"></i> 記事を生成
                    </button>
                </form>
            </div>
        </div>
        
        <!-- 結果表示エリア -->
        <div id="resultArea" class="mt-4" style="display: none;">
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0">生成結果</h5>
                </div>
                <div class="card-body" id="resultContent">
                    <!-- 結果がここに表示される -->
                </div>
            </div>
        </div>
    </div>
</div>

<script>
// シンプルなフォーム送信処理
document.getElementById('generateForm').addEventListener('submit', async function(e) {
    e.preventDefault();
    
    const btn = document.getElementById('generateBtn');
    const originalText = btn.innerHTML;
    btn.disabled = true;
    btn.innerHTML = '<span class="spinner-border spinner-border-sm me-2"></span>生成中...';
    
    try {
        const formData = {
            action: 'generate',
            title: document.getElementById('title').value,
            keywords: document.getElementById('keywords').value,
            model: document.getElementById('model').value,
            user_prompt: document.getElementById('user_prompt').value,
            output_format: 'visual',
            temperature: 0.7,
            max_tokens: 2000,
            save_history: true,
            enable_perplexity: false,
            enable_images: false
        };
        
        const response = await fetch('../api/service.php', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json'
            },
            body: JSON.stringify(formData)
        });
        
        const result = await response.json();
        
        if (result.success) {
            document.getElementById('resultArea').style.display = 'block';
            document.getElementById('resultContent').innerHTML = result.content;
            alert('記事生成が完了しました！');
        } else {
            alert('エラー: ' + (result.error || '不明なエラー'));
        }
    } catch (error) {
        alert('通信エラー: ' + error.message);
        console.error(error);
    } finally {
        btn.disabled = false;
        btn.innerHTML = originalText;
    }
});
</script>