<?php
// 記事編集ページ
$historyFile = __DIR__ . '/../../data/history.json';
$articlesFile = __DIR__ . '/../../data/articles.json';

$editId = $_GET['id'] ?? null;
$article = null;

// articles.jsonから検索
if ($editId && file_exists($articlesFile)) {
    $articles = json_decode(file_get_contents($articlesFile), true) ?: [];
    foreach ($articles as $item) {
        if ($item['id'] === $editId) {
            $article = $item;
            break;
        }
    }
}

// 見つからない場合はhistory.jsonから検索
if (!$article && $editId && file_exists($historyFile)) {
    $history = json_decode(file_get_contents($historyFile), true) ?: [];
    foreach ($history as $item) {
        if ($item['id'] === $editId) {
            $article = $item;
            break;
        }
    }
}

// それでも見つからない場合はduga-history.jsonから検索
$dugaHistoryFile = __DIR__ . '/../../data/duga-history.json';
if (!$article && $editId && file_exists($dugaHistoryFile)) {
    $dugaHistory = json_decode(file_get_contents($dugaHistoryFile), true) ?: [];
    foreach ($dugaHistory as $item) {
        if ($item['id'] === $editId) {
            $article = $item;
            break;
        }
    }
}

if (!$article) {
    echo '<div class="alert alert-danger">記事が見つかりません。</div>';
    exit;
}

// サイト設定を読み込み（JavaScript用）
$siteConfigFile = __DIR__ . '/../../data/site-configs.json';
$siteConfigs = [];
if (file_exists($siteConfigFile)) {
    $siteConfigs = json_decode(file_get_contents($siteConfigFile), true) ?: [];
}

// すべての記事から既存のカテゴリを収集
$allCategories = [];
$standardCategories = ['ビジネス', 'テクノロジー', 'ライフスタイル', '健康・美容', 'エンタメ', '教育', '金融', '旅行', 'グルメ', 'その他'];

// articles.jsonから
if (file_exists($articlesFile)) {
    $articles = json_decode(file_get_contents($articlesFile), true) ?: [];
    foreach ($articles as $item) {
        if (!empty($item['category']) && !in_array($item['category'], $standardCategories) && !in_array($item['category'], $allCategories)) {
            $allCategories[] = $item['category'];
        }
    }
}

// history.jsonから
if (file_exists($historyFile)) {
    $history = json_decode(file_get_contents($historyFile), true) ?: [];
    foreach ($history as $item) {
        if (!empty($item['category']) && !in_array($item['category'], $standardCategories) && !in_array($item['category'], $allCategories)) {
            $allCategories[] = $item['category'];
        }
    }
}

// カテゴリをソート
sort($allCategories);
?>

<!-- 外部CSSは使用しない - インラインスタイルで対応 -->
<style>
/* 記事編集ページの余白を削除 - <?php echo date('Y-m-d H:i:s'); ?> */

/* モバイルでハンバーガーメニューボタンを確実に表示 */
@media (max-width: 768px) {
    .sidebar-toggle-btn {
        z-index: 9999 !important;
        position: fixed !important;
        display: block !important;
        visibility: visible !important;
    }
    
    /* ページヘッダーがボタンを隠さないように */
    .page-header {
        margin-left: 60px !important;
        position: relative !important;
        z-index: 1 !important;
    }
    
    /* メインコンテンツのパディング調整 */
    .main-content {
        padding-top: 1rem !important;
    }
}

/* Bootstrapのmb-4クラスを上書き */
#editForm .mb-4 {
    margin-bottom: 1.5rem !important;
}

/* d-flexクラスの高さ制限 - editor.php専用 */
.d-flex.justify-content-between {
    max-height: none !important;
    overflow: visible !important;
}

.card-body .d-flex {
    max-height: none !important;
}

/* ボタングループは除外 */
.btn-group,
.btn-toolbar {
    max-height: none !important;
}

/* カテゴリー選択部分の余白を削除 */
#editForm > div:nth-child(4) {
    margin-bottom: 0.5rem !important;
}

/* 記事内容エディタの上部余白を削除 */
#editForm > div:nth-child(5) {
    margin-top: 0 !important;
}

/* エディタラベルとツールバーの間隔を削除 */
#editForm > div:nth-child(5) > div.d-flex {
    margin-bottom: 0.25rem !important;
}

/* エディタツールバーの余白を削除 */
.editor-toolbar {
    margin: 0 !important;
    padding: 0.5rem !important;
    background-color: #f8f9fa;
    border: 1px solid #dee2e6;
    border-bottom: none;
}

/* エディタ本体の上部をツールバーに密着 */
#editorWrapper {
    margin-top: 0 !important;
}

#editor {
    border: none !important;
    min-height: 100%;
    height: 100%;
    max-height: none;
    overflow-y: auto;
}

/* エディタのスタイル改善 */
.editor-content {
    font-size: 16px;
    line-height: 1.8;
    padding: 1rem;
}

#editorWrapper {
    border: 1px solid #dee2e6;
    border-radius: 0 0 0.375rem 0.375rem;
}

/* デバッグ用：ボーダーを追加して要素を可視化 */
/*
#editForm > div {
    border: 1px solid red;
}
*/

/* 強制的な高さ制限 - <?php echo time(); ?> */
div.mb-2.d-flex.justify-content-between {
    height: auto !important;
    max-height: none !important;
    display: flex !important;
    align-items: center !important;
}

/* 画像管理セクションの高さ制限 */
div.mb-4 > div.d-flex.justify-content-between {
    height: auto !important;
    max-height: none !important;
}

/* DMMサンプル画像セクションの余白調整 - 専用IDで他に影響しない */
#dmmSampleImagesSection {
    margin-bottom: 0.75rem !important;
}

#dmmSampleImagesSection .alert {
    margin-bottom: 0.5rem !important;
    padding: 0.5rem 0.75rem;
}

/* ラベルの余白削除 */
.form-label {
    margin-bottom: 0 !important;
    margin-top: 0 !important;
}

/* サイドバーの余白調整 */
.col-lg-3 .card {
    margin-bottom: 1rem !important;
}

.col-lg-3 .card-body {
    padding: 1rem !important;
}

.col-lg-3 .card-body p {
    margin-bottom: 0.5rem !important;
}

.col-lg-3 .card-body p:last-child {
    margin-bottom: 0 !important;
}

/* d-grid gap-2 のカスタマイズ */
.col-lg-3 .d-grid.gap-2 {
    gap: 0.5rem !important;
}

/* サイドバーのボタンサイズ調整 */
.col-lg-3 .btn-sm {
    padding: 0.25rem 0.5rem !important;
    font-size: 0.875rem !important;
}

/* 画像セクションの余白を最小化 */
.mb-4:has(.row.g-3) {
    margin-bottom: 0.5rem !important;
}

/* 画像カードの余白調整 */
.row.g-3 {
    --bs-gutter-y: 0.5rem !important;
    --bs-gutter-x: 0.5rem !important;
}

/* 画像カード内の余白を削減 */
.row.g-3 .card {
    margin-bottom: 0 !important;
}

.row.g-3 .card-body {
    padding: 0.5rem !important;
}

/* 画像セクションのラベルと説明文の余白 */
.mb-4 > label.form-label {
    margin-bottom: 0.25rem !important;
}

.mb-4 > .d-flex {
    margin-bottom: 0.5rem !important;
}

/* カード内の入力フィールドとボタンの余白 */
.card-body.p-2 {
    padding: 0.5rem !important;
    max-height: none !important;
}

.card-body .form-control-sm {
    margin-bottom: 0.5rem !important;
}
</style>

<!-- ナビゲーションバー -->
<div class="d-flex justify-content-between align-items-center mb-3">
    <div class="page-header mb-0">
        <h1 class="mb-0"><i class="bi bi-pencil-square"></i> 記事編集</h1>
        <p class="text-muted mb-0">生成した記事の編集・調整</p>
    </div>
    <div class="d-flex gap-2">
        <a href="?page=history" class="btn btn-outline-secondary">
            <i class="bi bi-arrow-left"></i> 生成履歴に戻る
        </a>
        <a href="?page=dashboard" class="btn btn-outline-primary">
            <i class="bi bi-house"></i> ダッシュボード
        </a>
    </div>
</div>

<div class="row">
    <div class="col-lg-9">
        <div class="card">
            <div class="card-body">
                <form id="editForm">
                    <input type="hidden" id="articleId" value="<?php echo htmlspecialchars($editId); ?>">
                    
                    <div class="mb-4">
                        <label for="title" class="form-label">記事タイトル</label>
                        <input type="text" class="form-control form-control-lg" id="title" 
                               value="<?php echo htmlspecialchars(strip_tags($article['title'])); ?>" required>
                    </div>
                    
                    <div class="mb-4">
                        <label for="keywords" class="form-label">キーワード</label>
                        <input type="text" class="form-control" id="keywords" 
                               value="<?php echo htmlspecialchars($article['keywords'] ?? ''); ?>"
                               placeholder="カンマ区切りで入力">
                    </div>
                    
                    <div class="mb-4">
                        <label for="tags" class="form-label">タグ</label>
                        <input type="text" class="form-control" id="tags" 
                               value="<?php echo htmlspecialchars($article['tags'] ?? ''); ?>"
                               placeholder="カンマ区切りで入力（例: AI, ブログ, 自動生成）">
                        <small class="form-text text-muted">タグクラウドに表示されるタグを設定します</small>
                    </div>
                    
                    <div class="mb-4">
                        <label for="category" class="form-label">カテゴリー</label>
                        <div class="input-group">
                            <select class="form-control" id="category">
                                <option value="">-- カテゴリーを選択 --</option>
                                <option value="ビジネス" <?php echo ($article['category'] ?? '') === 'ビジネス' ? 'selected' : ''; ?>>ビジネス</option>
                                <option value="テクノロジー" <?php echo ($article['category'] ?? '') === 'テクノロジー' ? 'selected' : ''; ?>>テクノロジー</option>
                                <option value="ライフスタイル" <?php echo ($article['category'] ?? '') === 'ライフスタイル' ? 'selected' : ''; ?>>ライフスタイル</option>
                                <option value="健康・美容" <?php echo ($article['category'] ?? '') === '健康・美容' ? 'selected' : ''; ?>>健康・美容</option>
                                <option value="エンタメ" <?php echo ($article['category'] ?? '') === 'エンタメ' ? 'selected' : ''; ?>>エンタメ</option>
                                <option value="教育" <?php echo ($article['category'] ?? '') === '教育' ? 'selected' : ''; ?>>教育</option>
                                <option value="金融" <?php echo ($article['category'] ?? '') === '金融' ? 'selected' : ''; ?>>金融</option>
                                <option value="旅行" <?php echo ($article['category'] ?? '') === '旅行' ? 'selected' : ''; ?>>旅行</option>
                                <option value="グルメ" <?php echo ($article['category'] ?? '') === 'グルメ' ? 'selected' : ''; ?>>グルメ</option>
                                <option value="その他" <?php echo ($article['category'] ?? '') === 'その他' ? 'selected' : ''; ?>>その他</option>
                                <?php foreach ($allCategories as $cat): ?>
                                <option value="<?php echo htmlspecialchars($cat); ?>" <?php echo ($article['category'] ?? '') === $cat ? 'selected' : ''; ?>><?php echo htmlspecialchars($cat); ?></option>
                                <?php endforeach; ?>
                                <option value="add-new-category">＋ 新規カテゴリーを追加</option>
                            </select>
                            <input type="text" class="form-control" id="custom_category" 
                                   placeholder="新規カテゴリー" style="max-width: 200px;"
                                   value="<?php 
                                   $currentCategory = $article['category'] ?? '';
                                   $standardCategories = ['ビジネス', 'テクノロジー', 'ライフスタイル', '健康・美容', 'エンタメ', '教育', '金融', '旅行', 'グルメ', 'その他', ''];
                                   echo !in_array($currentCategory, $standardCategories) ? htmlspecialchars($currentCategory) : '';
                                   ?>">
                        </div>
                        <small class="form-text text-muted">既存カテゴリーを選択するか、新しいカテゴリーを入力してください</small>
                    </div>
                    
                    <!-- コンテンツエディタセクション -->
                    <div class="mb-4">
                        <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 0.5rem; height: 35px;">
                            <label for="content" class="form-label" style="margin: 0;">記事内容</label>
                            <?php if (!empty($belongingSites)): ?>
                            <div class="btn-group btn-group-sm" role="group">
                                <input type="radio" class="btn-check" name="designMode" id="designNone" autocomplete="off" checked>
                                <label class="btn btn-outline-secondary" for="designNone" onclick="applyDesignMode('none')">
                                    <i class="bi bi-file-earmark-text"></i> デザインなし
                                </label>
                                <?php 
                                $firstSiteId = array_key_first($belongingSites);
                                foreach ($belongingSites as $configId => $siteName): 
                                ?>
                                <input type="radio" class="btn-check" name="designMode" id="design<?php echo $configId; ?>" autocomplete="off">
                                <label class="btn btn-outline-primary" for="design<?php echo $configId; ?>" onclick="applyDesignMode('<?php echo $configId; ?>')">
                                    <i class="bi bi-palette"></i> <?php echo htmlspecialchars($siteName); ?>
                                </label>
                                <?php endforeach; ?>
                            </div>
                            <?php endif; ?>
                        </div>
                        
                        <!-- エディタツールバー -->
                        <div class="editor-toolbar">
                            <div class="btn-toolbar" role="toolbar">
                                <div class="btn-group me-2" role="group">
                                    <button type="button" class="btn btn-sm btn-outline-secondary" onclick="formatText('bold')" title="太字">
                                        <i class="bi bi-type-bold"></i>
                                    </button>
                                    <button type="button" class="btn btn-sm btn-outline-secondary" onclick="formatText('italic')" title="斜体">
                                        <i class="bi bi-type-italic"></i>
                                    </button>
                                    <button type="button" class="btn btn-sm btn-outline-secondary" onclick="formatText('underline')" title="下線">
                                        <i class="bi bi-type-underline"></i>
                                    </button>
                                </div>
                                
                                <div class="btn-group me-2" role="group">
                                    <button type="button" class="btn btn-sm btn-outline-secondary" onclick="formatHeading('h2')" title="見出し2">
                                        H2
                                    </button>
                                    <button type="button" class="btn btn-sm btn-outline-secondary" onclick="formatHeading('h3')" title="見出し3">
                                        H3
                                    </button>
                                    <button type="button" class="btn btn-sm btn-outline-secondary" onclick="formatHeading('h4')" title="見出し4">
                                        H4
                                    </button>
                                </div>
                                
                                <div class="btn-group me-2" role="group">
                                    <button type="button" class="btn btn-sm btn-outline-secondary" onclick="insertList('ul')" title="箇条書き">
                                        <i class="bi bi-list-ul"></i>
                                    </button>
                                    <button type="button" class="btn btn-sm btn-outline-secondary" onclick="insertList('ol')" title="番号付きリスト">
                                        <i class="bi bi-list-ol"></i>
                                    </button>
                                </div>
                                
                                <div class="btn-group me-2" role="group">
                                    <button type="button" class="btn btn-sm btn-outline-secondary" onclick="insertLink()" title="リンク">
                                        <i class="bi bi-link-45deg"></i>
                                    </button>
                                    <button type="button" class="btn btn-sm btn-outline-secondary" onclick="insertImage()" title="画像">
                                        <i class="bi bi-image"></i>
                                    </button>
                                </div>
                                
                                <div class="btn-group" role="group">
                                    <button type="button" class="btn btn-sm btn-outline-secondary" onclick="toggleView()" title="HTML表示">
                                        <i class="bi bi-code-slash"></i>
                                    </button>
                                    <button type="button" class="btn btn-sm btn-outline-secondary" onclick="aiRewrite()" title="AIリライト">
                                        <i class="bi bi-magic"></i> AI
                                    </button>
                                </div>
                            </div>
                        </div>
                        
                        <div id="editorWrapper" class="editor-wrapper">
                            <div id="editor" class="form-control editor-content" contenteditable="true">
                                <?php echo $article['content']; ?>
                            </div>
                        </div>
                        <textarea id="htmlEditor" class="form-control editor-html" style="display: none;">
                            <?php echo htmlspecialchars($article['content']); ?>
                        </textarea>
                    </div>
                    
                    <!-- 画像管理 -->
                    <?php 
                    // DMM記事の場合は画像セクションを表示しない
                    $isDmmArticle = isset($article['metadata']['type']) && $article['metadata']['type'] === 'dmm';
                    
                    // 実際に表示可能な画像があるかチェック
                    $hasValidImages = false;
                    if (!$isDmmArticle && !empty($article['images']) && is_array($article['images'])) {
                        foreach ($article['images'] as $image) {
                            if (!empty($image['url'])) {
                                $hasValidImages = true;
                                break;
                            }
                        }
                    }
                    
                    if ($hasValidImages): ?>
                    <div class="mb-4">
                        <label class="form-label">記事内の画像</label>
                        <?php if (count($article['images']) > 0): ?>
                        <div class="d-flex justify-content-end mb-2">
                            <button type="button" class="btn btn-sm btn-success" 
                                    onclick="window.downloadAllImages(currentImages, document.getElementById('title').value)">
                                <i class="bi bi-download"></i> すべてダウンロード
                            </button>
                        </div>
                        <?php endif; ?>
                        <div class="row g-3">
                            <?php foreach ($article['images'] as $index => $image): ?>
                            <div class="col-md-4">
                                <div class="card">
                                    <img src="<?php echo htmlspecialchars($image['url']); ?>" 
                                         class="card-img-top" alt="<?php echo htmlspecialchars($image['alt']); ?>">
                                    <div class="card-body p-2">
                                        <input type="text" class="form-control form-control-sm mb-2" 
                                               value="<?php echo htmlspecialchars($image['alt']); ?>"
                                               placeholder="ALTテキスト" id="imgAlt<?php echo $index; ?>">
                                        <div class="btn-group w-100" role="group">
                                            <button type="button" class="btn btn-sm btn-outline-primary" 
                                                    onclick="saveSelectionAndInsertImage('<?php echo $image['url']; ?>', '<?php echo $image['alt']; ?>')">
                                                挿入
                                            </button>
                                            <button type="button" class="btn btn-sm btn-outline-info" 
                                                    onclick="window.downloadImage('<?php echo addslashes($image['url']); ?>', '<?php echo addslashes($image['alt']); ?>.jpg')">
                                                DL
                                            </button>
                                            <button type="button" class="btn btn-sm btn-outline-danger" 
                                                    onclick="removeImage(<?php echo $index; ?>)">
                                                削除
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                    <?php endif; ?>
                    
                    <!-- DMMサンプル画像 -->
                    <?php if (isset($article['metadata']['type']) && $article['metadata']['type'] === 'dmm' && 
                              isset($article['metadata']['dmm_data']['sample_images']) && 
                              !empty($article['metadata']['dmm_data']['sample_images'])): ?>
                    <div class="mb-3" id="dmmSampleImagesSection">
                        <label class="form-label">DMM商品サンプル画像
                            <button type="button" class="btn btn-primary btn-sm float-end" id="insertAllDmmImagesBtn">
                                <i class="bi bi-images"></i> すべて挿入
                            </button>
                        </label>
                        <div class="alert alert-info mt-2">
                            <i class="bi bi-info-circle"></i> DMM商品のサンプル画像です。クリックして記事に挿入できます。
                        </div>
                        <div class="row g-3">
                            <?php foreach ($article['metadata']['dmm_data']['sample_images'] as $index => $sampleImage): ?>
                            <div class="col-md-4">
                                <div class="card">
                                    <img src="<?php echo htmlspecialchars($sampleImage); ?>" 
                                         class="card-img-top" alt="DMM商品サンプル画像<?php echo $index + 1; ?>">
                                    <div class="card-body p-2">
                                        <div class="btn-group w-100" role="group">
                                            <button type="button" class="btn btn-sm btn-outline-primary" 
                                                    onclick="saveSelectionAndInsertImage('<?php echo $sampleImage; ?>', 'DMM商品サンプル画像<?php echo $index + 1; ?>')">
                                                記事に挿入
                                            </button>
                                            <button type="button" class="btn btn-sm btn-outline-info" 
                                                    onclick="window.open('<?php echo $sampleImage; ?>', '_blank')">
                                                拡大表示
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                    <?php endif; ?>
                    
                    <!-- DUGAサンプル画像 -->
                    <?php if (isset($article['metadata']['type']) && $article['metadata']['type'] === 'duga' && 
                              isset($article['metadata']['duga_data']['sample_images']) && 
                              !empty($article['metadata']['duga_data']['sample_images'])): ?>
                    <div class="mb-3" id="dugaSampleImagesSection">
                        <label class="form-label">DUGA商品サンプル画像
                            <button type="button" class="btn btn-primary btn-sm float-end" id="insertAllDugaImagesBtn">
                                <i class="bi bi-images"></i> すべて挿入
                            </button>
                        </label>
                        <div class="alert alert-info mt-2">
                            <i class="bi bi-info-circle"></i> DUGA商品のサンプル画像です。クリックして記事に挿入できます。
                        </div>
                        <div class="row g-3">
                            <?php foreach ($article['metadata']['duga_data']['sample_images'] as $index => $sampleImage): ?>
                            <div class="col-md-4">
                                <div class="card">
                                    <img src="<?php echo htmlspecialchars($sampleImage); ?>" 
                                         class="card-img-top" alt="DUGA商品サンプル画像<?php echo $index + 1; ?>">
                                    <div class="card-body p-2">
                                        <div class="btn-group w-100" role="group">
                                            <button type="button" class="btn btn-sm btn-outline-primary" 
                                                    onclick="saveSelectionAndInsertImage('<?php echo $sampleImage; ?>', 'DUGA商品サンプル画像<?php echo $index + 1; ?>')">
                                                記事に挿入
                                            </button>
                                            <button type="button" class="btn btn-sm btn-outline-info" 
                                                    onclick="window.open('<?php echo $sampleImage; ?>', '_blank')">
                                                拡大表示
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                    <?php endif; ?>
                    
                    <!-- DUGAサンプル動画 -->
                    <?php if (isset($article['metadata']['type']) && $article['metadata']['type'] === 'duga' && 
                              isset($article['metadata']['duga_data']['sample_movie']) && 
                              !empty($article['metadata']['duga_data']['sample_movie'])): ?>
                    <div class="mb-3" id="dugaSampleMovieSection">
                        <label class="form-label">DUGA商品サンプル動画</label>
                        <div class="alert alert-info mt-2">
                            <i class="bi bi-info-circle"></i> DUGA商品のサンプル動画です。クリックして記事に挿入できます。
                        </div>
                        <div class="card">
                            <div class="card-body">
                                <video controls style="width: 100%; max-width: 600px;"
                                    <?php if (!empty($article['metadata']['duga_data']['sample_movie_capture'])): ?>
                                    poster="<?php echo htmlspecialchars($article['metadata']['duga_data']['sample_movie_capture']); ?>"
                                    <?php endif; ?>>
                                    <source src="<?php echo htmlspecialchars($article['metadata']['duga_data']['sample_movie']); ?>" type="video/mp4">
                                    お使いのブラウザは動画再生に対応していません。
                                </video>
                                <div class="mt-2">
                                    <button type="button" class="btn btn-primary btn-sm" 
                                            onclick="insertDugaSampleMovie('<?php echo htmlspecialchars($article['metadata']['duga_data']['sample_movie']); ?>', '<?php echo htmlspecialchars($article['metadata']['duga_data']['sample_movie_capture'] ?? ''); ?>')">
                                        <i class="bi bi-film"></i> 動画を記事に挿入
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php endif; ?>
                    
                    <!-- SEO設定 -->
                    <div class="card mb-4">
                        <div class="card-header">
                            <h5 class="mb-0"><i class="bi bi-search"></i> SEO設定</h5>
                        </div>
                        <div class="card-body">
                            <div class="mb-3">
                                <label for="metaTitle" class="form-label">メタタイトル</label>
                                <div class="input-group">
                                    <input type="text" class="form-control" id="metaTitle" 
                                           value="<?php echo htmlspecialchars($article['meta_title'] ?? ''); ?>"
                                           placeholder="空の場合は記事タイトルが使用されます（60文字以内）" maxlength="60">
                                    <button class="btn btn-outline-secondary" type="button" onclick="generateMetaTitle()">
                                        <i class="bi bi-magic"></i> 自動生成（準備中）
                                    </button>
                                </div>
                                <small class="text-muted"><span id="metaTitleCount">0</span>/60文字</small>
                            </div>
                            <div class="mb-3">
                                <label for="metaDescription" class="form-label">メタディスクリプション</label>
                                <div class="input-group">
                                    <textarea class="form-control" id="metaDescription" rows="3" 
                                              placeholder="空の場合は記事内容から自動生成されます（160文字以内）" maxlength="160"><?php echo htmlspecialchars($article['meta_description'] ?? ''); ?></textarea>
                                    <button class="btn btn-outline-secondary" type="button" onclick="generateMetaDescription()">
                                        <i class="bi bi-magic"></i> 自動生成（準備中）
                                    </button>
                                </div>
                                <small class="text-muted"><span id="metaDescCount">0</span>/160文字</small>
                            </div>
                            <div class="mb-3">
                                <label for="slug" class="form-label">URLスラッグ</label>
                                <div class="input-group">
                                    <input type="text" class="form-control" id="slug" 
                                           value="<?php echo htmlspecialchars($article['slug'] ?? ''); ?>"
                                           placeholder="article-title-example">
                                    <button class="btn btn-outline-secondary" type="button" onclick="generateSlugFromTitle()">
                                        <i class="bi bi-arrow-repeat"></i> タイトルから生成
                                    </button>
                                </div>
                                <small class="text-muted">英数字、ハイフン、アンダースコアのみ使用可能です。日本語は使用しないでください。</small>
                            </div>
                        </div>
                    </div>
                    
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <button type="submit" class="btn btn-primary">
                                <i class="bi bi-save"></i> 保存
                            </button>
                            <button type="button" class="btn btn-info" onclick="saveAndReturn()">
                                <i class="bi bi-save"></i> 保存して履歴に戻る
                            </button>
                            <button type="button" class="btn btn-success" onclick="saveAndPublish()">
                                <i class="bi bi-send"></i> 保存して公開
                            </button>
                        </div>
                        <div>
                            <?php if (!empty($belongingSites)): ?>
                            <div class="btn-group" role="group">
                                <button type="button" class="btn btn-outline-secondary dropdown-toggle" data-bs-toggle="dropdown">
                                    <i class="bi bi-eye"></i> プレビュー
                                </button>
                                <ul class="dropdown-menu">
                                    <li><a class="dropdown-item" href="#" onclick="previewArticle(); return false;">
                                        <i class="bi bi-file-text"></i> シンプルプレビュー
                                    </a></li>
                                    <li><hr class="dropdown-divider"></li>
                                    <?php foreach ($belongingSites as $configId => $siteName): ?>
                                    <li><a class="dropdown-item" href="#" onclick="previewWithSiteDesign('<?php echo $configId; ?>', '<?php echo htmlspecialchars($siteName); ?>'); return false;">
                                        <i class="bi bi-globe"></i> <?php echo htmlspecialchars($siteName); ?>のデザインで表示
                                    </a></li>
                                    <?php endforeach; ?>
                                </ul>
                            </div>
                            <?php else: ?>
                            <button type="button" class="btn btn-outline-secondary" onclick="previewArticle()">
                                <i class="bi bi-eye"></i> プレビュー
                            </button>
                            <?php endif; ?>
                            <a href="index.php?page=dashboard" class="btn btn-outline-secondary">
                                キャンセル
                            </a>
                        </div>
                    </div>
                    
                    <!-- ナビゲーションリンク -->
                    <div class="mt-3 pt-3 border-top">
                        <div class="d-flex gap-3 justify-content-center">
                            <a href="?page=history" class="text-decoration-none">
                                <i class="bi bi-clock-history"></i> 生成履歴一覧
                            </a>
                            <span class="text-muted">|</span>
                            <a href="?page=dashboard" class="text-decoration-none">
                                <i class="bi bi-speedometer2"></i> ダッシュボード
                            </a>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
    
    <div class="col-lg-3">
        <!-- 編集サイドバー -->
        <div class="card mb-3">
            <div class="card-header">
                <h5 class="mb-0"><i class="bi bi-info-circle"></i> 記事情報</h5>
            </div>
            <div class="card-body">
                <p class="mb-2"><strong>作成日時:</strong><br><?php echo $article['created_at']; ?></p>
                <p class="mb-2"><strong>使用モデル:</strong><br><?php echo $article['model']; ?></p>
                <p class="mb-2"><strong>カテゴリー:</strong><br><?php echo htmlspecialchars($article['category'] ?? 'その他'); ?></p>
                <p class="mb-2"><strong>文字数:</strong> <span id="charCount">0</span>文字</p>
                <p class="mb-2"><strong>画像数:</strong> <?php echo count($article['images'] ?? []); ?>枚</p>
                
                <?php
                // この記事が属するサイトを検索
                $siteConfigFile = __DIR__ . '/../../data/site-configs.json';
                $belongingSites = [];
                if (file_exists($siteConfigFile)) {
                    $siteConfigs = json_decode(file_get_contents($siteConfigFile), true) ?: [];
                    foreach ($siteConfigs as $configId => $siteConfig) {
                        if (isset($siteConfig['article_ids']) && in_array($article['id'], $siteConfig['article_ids'])) {
                            $belongingSites[$configId] = $siteConfig['display_name'];
                        }
                    }
                }
                
                if (!empty($belongingSites)):
                ?>
                <hr>
                <p class="mb-2"><strong>所属サイト:</strong></p>
                <ul class="list-unstyled small">
                    <?php foreach ($belongingSites as $configId => $siteName): ?>
                    <li>
                        <i class="bi bi-globe"></i> 
                        <a href="?page=site-update" class="text-decoration-none">
                            <?php echo htmlspecialchars($siteName); ?>
                        </a>
                    </li>
                    <?php endforeach; ?>
                </ul>
                <?php endif; ?>
            </div>
        </div>
        
        <!-- AI アシスタント -->
        <div class="card mb-3">
            <div class="card-header">
                <h5 class="mb-0"><i class="bi bi-robot"></i> AI アシスタント</h5>
            </div>
            <div class="card-body">
                <div class="d-grid gap-2">
                    <button type="button" class="btn btn-outline-primary btn-sm" onclick="aiImprove()">
                        文章を改善
                    </button>
                    <button type="button" class="btn btn-outline-primary btn-sm" onclick="aiExpand()">
                        内容を拡張
                    </button>
                    <button type="button" class="btn btn-outline-primary btn-sm" onclick="aiSummarize()">
                        要約を生成
                    </button>
                    <button type="button" class="btn btn-outline-primary btn-sm" onclick="aiSEO()">
                        SEO最適化
                    </button>
                    <button type="button" class="btn btn-outline-primary btn-sm" onclick="aiGenerateImage()">
                        画像を追加生成
                    </button>
                </div>
            </div>
        </div>
        
        <!-- 編集のヒント -->
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0"><i class="bi bi-lightbulb"></i> 編集のヒント</h5>
            </div>
            <div class="card-body">
                <h6>ショートカット</h6>
                <ul class="small">
                    <li><kbd>Ctrl+B</kbd> - 太字</li>
                    <li><kbd>Ctrl+I</kbd> - 斜体</li>
                    <li><kbd>Ctrl+U</kbd> - 下線</li>
                    <li><kbd>Ctrl+S</kbd> - 保存</li>
                </ul>
                
                <h6 class="mt-3">SEOのポイント</h6>
                <ul class="small">
                    <li>タイトルは32文字以内が理想</li>
                    <li>見出しにキーワードを含める</li>
                    <li>画像にはALTテキストを設定</li>
                    <li>内部リンクを適切に配置</li>
                </ul>
            </div>
        </div>
    </div>
</div>

<!-- プレビューモーダル -->
<div class="modal fade" id="previewModal" tabindex="-1">
    <div class="modal-dialog modal-xl">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">記事プレビュー</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div id="previewContent"></div>
            </div>
        </div>
    </div>
</div>

<script>
let isHtmlView = false;
let currentImages = <?php echo json_encode($article['images'] ?? []); ?>;

// DUGAサンプル動画を挿入
window.insertDugaSampleMovie = function(movieUrl, posterUrl) {
    const editor = document.getElementById('editor');
    if (!editor) {
        alert('エディタが見つかりません');
        return;
    }
    
    // 動画のHTMLを生成
    let html = `\n<div class="duga-sample-movie" style="text-align: center; margin: 20px 0;">\n<video controls style="max-width: 100%; height: auto;"`;
    if (posterUrl) {
        html += ` poster="${posterUrl}"`;
    }
    html += `>\n<source src="${movieUrl}" type="video/mp4">\nお使いのブラウザは動画再生に対応していません。\n</video>\n</div>\n`;
    
    // エディタの現在のキャレット位置に挿入
    const selection = window.getSelection();
    const range = selection.getRangeAt(0);
    
    // HTMLを挿入
    const tempDiv = document.createElement('div');
    tempDiv.innerHTML = html;
    
    const fragment = document.createDocumentFragment();
    while (tempDiv.firstChild) {
        fragment.appendChild(tempDiv.firstChild);
    }
    
    range.deleteContents();
    range.insertNode(fragment);
    
    // キャレットを挿入したコンテンツの後に移動
    range.collapse(false);
    selection.removeAllRanges();
    selection.addRange(range);
    
    showSuccessToast('サンプル動画を挿入しました');
};

// DUGAサンプル画像をすべて挿入
window.insertAllDugaImages = function() {
    console.log('insertAllDugaImages called');
    
    const editor = document.getElementById('editor');
    console.log('Editor element:', editor);
    
    if (!editor) {
        console.error('Editor element not found');
        alert('エディタが見つかりません');
        return;
    }
    
    // DUGAサンプル画像のデータを取得
    <?php if (isset($article['metadata']['duga_data']['sample_images'])): ?>
    const dugaData = <?php echo json_encode($article['metadata']['duga_data']['sample_images'] ?? []); ?>;
    console.log('DUGA data:', dugaData);
    <?php else: ?>
    const dugaData = [];
    <?php endif; ?>
    
    if (!dugaData || dugaData.length === 0) {
        console.warn('No DUGA sample images found');
        alert('DUGA商品のサンプル画像が見つかりません');
        return;
    }
    
    // 画像のHTMLを生成
    let html = '\n<div class="duga-sample-images">\n';
    dugaData.forEach((imgUrl, index) => {
        const altText = `DUGA商品サンプル画像${index + 1}`;
        html += `<img src="${imgUrl}" alt="${altText}" style="max-width: 100%; margin: 10px 0;">\n`;
    });
    html += '</div>\n';
    
    console.log('Inserting HTML:', html);
    
    // エディタの現在のキャレット位置に挿入
    const selection = window.getSelection();
    const range = selection.getRangeAt(0);
    
    // HTMLを挿入
    const tempDiv = document.createElement('div');
    tempDiv.innerHTML = html;
    
    const fragment = document.createDocumentFragment();
    while (tempDiv.firstChild) {
        fragment.appendChild(tempDiv.firstChild);
    }
    
    range.deleteContents();
    range.insertNode(fragment);
    
    // キャレットを挿入したコンテンツの後に移動
    range.collapse(false);
    selection.removeAllRanges();
    selection.addRange(range);
    
    // 保存ボタンを有効化
    showSuccessToast('すべてのDUGAサンプル画像を挿入しました');
};

// DMMサンプル画像をすべて挿入 - グローバル関数として最初に定義
window.insertAllDmmImages = function() {
    console.log('insertAllDmmImages called');
    
    const editor = document.getElementById('editor');
    console.log('Editor element:', editor);
    
    if (!editor) {
        console.error('Editor element not found');
        alert('エディタが見つかりません');
        return;
    }
    
    // DMMサンプル画像のデータを取得
    <?php if (isset($article['metadata']['dmm_data']['sample_images'])): ?>
    const dmmData = <?php echo json_encode($article['metadata']['dmm_data']['sample_images'] ?? []); ?>;
    console.log('DMM data:', dmmData);
    <?php else: ?>
    const dmmData = [];
    console.log('No DMM data available');
    <?php endif; ?>
    
    if (!dmmData || dmmData.length === 0) {
        alert('挿入する画像がありません');
        return;
    }
    
    // エディタにフォーカス
    editor.focus();
    
    // 現在のカーソル位置を保存
    const selection = window.getSelection();
    let range;
    if (selection.rangeCount > 0) {
        range = selection.getRangeAt(0);
    } else {
        // カーソル位置がない場合は末尾に設定
        range = document.createRange();
        range.selectNodeContents(editor);
        range.collapse(false);
    }
    
    // 画像を一つずつ挿入
    dmmData.forEach((imageUrl, index) => {
        const altText = `DMM商品サンプル画像${index + 1}`;
        
        // HTMLを作成
        const figureHtml = `<figure class="text-center my-4">
            <img src="${imageUrl.replace(/"/g, '&quot;').replace(/'/g, '&#39;')}" 
                 alt="${altText}" 
                 class="img-fluid rounded">
            <figcaption class="text-muted small mt-2">${altText}</figcaption>
        </figure>`;
        
        // 一時的なdivに入れてDOMノードに変換
        const tempDiv = document.createElement('div');
        tempDiv.innerHTML = figureHtml;
        
        // rangeに挿入
        while (tempDiv.firstChild) {
            range.insertNode(tempDiv.firstChild);
            // 次の挿入位置を画像の後に設定
            range.collapse(false);
        }
        
        // 画像間に改行を追加（最後の画像以外）
        if (index < dmmData.length - 1) {
            const br = document.createElement('br');
            range.insertNode(br);
            range.setStartAfter(br);
            range.collapse(true);
        }
    });
    
    // カーソルを最後の画像の後に移動
    selection.removeAllRanges();
    selection.addRange(range);
    
    // 文字数を更新
    updateCharCount();
    
    showToast(`${dmmData.length}枚の画像を挿入しました`, 'success');
};

// エディタの初期化
document.addEventListener('DOMContentLoaded', function() {
    // エディタが編集可能か確認
    const editor = document.getElementById('editor');
    if (editor) {
        console.log('Editor found, contenteditable:', editor.contentEditable);
        if (editor.contentEditable !== 'true') {
            editor.contentEditable = true;
            console.log('Set contenteditable to true');
        }
    }
    
    updateCharCount();
    setupMetaCounters();
    setupKeyboardShortcuts();
    setupEditorResize();
    
    // DMM記事の場合、画像をローカライズ
    <?php if (isset($article['metadata']['type']) && $article['metadata']['type'] === 'dmm'): ?>
    localizeDMMImages();
    
    // DMM一括挿入ボタンのイベントリスナーを設定
    const insertAllBtn = document.getElementById('insertAllDmmImagesBtn');
    if (insertAllBtn) {
        insertAllBtn.addEventListener('click', function() {
            if (typeof window.insertAllDmmImages === 'function') {
                window.insertAllDmmImages();
            } else {
                console.error('insertAllDmmImages function not found');
            }
        });
    }
    <?php endif; ?>
    
    <?php if (isset($article['metadata']['type']) && $article['metadata']['type'] === 'duga'): ?>
    // DUGA一括挿入ボタンのイベントリスナーを設定
    const insertAllDugaBtn = document.getElementById('insertAllDugaImagesBtn');
    if (insertAllDugaBtn) {
        insertAllDugaBtn.addEventListener('click', function() {
            if (typeof window.insertAllDugaImages === 'function') {
                window.insertAllDugaImages();
            } else {
                console.error('insertAllDugaImages function not found');
            }
        });
    }
    <?php endif; ?>
});

// 文字数カウント
function updateCharCount() {
    const editor = document.getElementById('editor');
    const text = editor.textContent || editor.innerText;
    document.getElementById('charCount').textContent = text.length;
}

// メタ情報の文字数カウンター
function setupMetaCounters() {
    document.getElementById('metaTitle').addEventListener('input', function() {
        document.getElementById('metaTitleCount').textContent = this.value.length;
    });
    
    document.getElementById('metaDescription').addEventListener('input', function() {
        document.getElementById('metaDescCount').textContent = this.value.length;
    });
}

// キーボードショートカット
function setupKeyboardShortcuts() {
    document.getElementById('editor').addEventListener('keydown', function(e) {
        if (e.ctrlKey || e.metaKey) {
            switch(e.key) {
                case 'b':
                    e.preventDefault();
                    formatText('bold');
                    break;
                case 'i':
                    e.preventDefault();
                    formatText('italic');
                    break;
                case 'u':
                    e.preventDefault();
                    formatText('underline');
                    break;
                case 's':
                    e.preventDefault();
                    document.getElementById('editForm').dispatchEvent(new Event('submit'));
                    break;
            }
        }
    });
}

// テキスト装飾
function formatText(command) {
    document.execCommand(command, false, null);
    document.getElementById('editor').focus();
}

// 見出し挿入
function formatHeading(tag) {
    const selection = window.getSelection();
    const text = selection.toString();
    
    if (text) {
        document.execCommand('formatBlock', false, tag);
    } else {
        const heading = document.createElement(tag);
        heading.textContent = '見出しテキスト';
        
        const range = selection.getRangeAt(0);
        range.insertNode(heading);
        
        // カーソルを見出しの後に移動
        range.setStartAfter(heading);
        range.collapse(true);
        selection.removeAllRanges();
        selection.addRange(range);
    }
    
    document.getElementById('editor').focus();
}

// リスト挿入
function insertList(type) {
    if (type === 'ul') {
        document.execCommand('insertUnorderedList', false, null);
    } else {
        document.execCommand('insertOrderedList', false, null);
    }
    document.getElementById('editor').focus();
}

// リンク挿入
function insertLink() {
    const url = prompt('リンクURLを入力してください:');
    if (url) {
        const text = window.getSelection().toString() || url;
        document.execCommand('createLink', false, url);
    }
    document.getElementById('editor').focus();
}

// 画像挿入
function insertImage() {
    console.log('insertImage function called');
    
    // エディタが存在するか確認
    const editor = document.getElementById('editor');
    if (!editor) {
        console.error('Editor not found');
        alert('エディタが見つかりません');
        return;
    }
    
    // 現在の選択範囲を保存
    const selection = window.getSelection();
    if (selection.rangeCount > 0) {
        savedSelection = selection.getRangeAt(0).cloneRange();
        console.log('Saved selection range');
    }
    
    // 画像挿入ダイアログを表示
    const dialog = `
        <div class="modal fade" id="imageInsertModal" tabindex="-1">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">画像を挿入</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                    </div>
                    <div class="modal-body">
                        <ul class="nav nav-tabs mb-3" role="tablist">
                            <li class="nav-item">
                                <button class="nav-link active" data-bs-toggle="tab" data-bs-target="#uploadTab" type="button">
                                    <i class="bi bi-upload"></i> アップロード
                                </button>
                            </li>
                            <li class="nav-item">
                                <button class="nav-link" data-bs-toggle="tab" data-bs-target="#urlTab" type="button">
                                    <i class="bi bi-link"></i> URL
                                </button>
                            </li>
                        </ul>
                        
                        <div class="tab-content">
                            <div class="tab-pane fade show active" id="uploadTab">
                                <input type="file" class="form-control mb-3" id="imageFile" accept="image/*">
                                <div id="uploadPreview" class="text-center mb-3" style="display: none;">
                                    <img src="" alt="" class="img-fluid" style="max-height: 200px;">
                                </div>
                                <input type="text" class="form-control" id="uploadAlt" placeholder="画像の説明（ALTテキスト）">
                            </div>
                            
                            <div class="tab-pane fade" id="urlTab">
                                <input type="url" class="form-control mb-3" id="imageUrl" placeholder="https://example.com/image.jpg">
                                <input type="text" class="form-control" id="urlAlt" placeholder="画像の説明（ALTテキスト）">
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">キャンセル</button>
                        <button type="button" class="btn btn-primary" onclick="confirmInsertImage()">挿入</button>
                    </div>
                </div>
            </div>
        </div>
    `;
    
    // 既存のモーダルがあれば削除
    const existingModal = document.getElementById('imageInsertModal');
    if (existingModal) {
        existingModal.remove();
    }
    
    // モーダルを追加して表示
    document.body.insertAdjacentHTML('beforeend', dialog);
    const modal = new bootstrap.Modal(document.getElementById('imageInsertModal'));
    modal.show();
    
    // ファイル選択時のプレビュー
    document.getElementById('imageFile').addEventListener('change', function(e) {
        const file = e.target.files[0];
        if (file && file.type.startsWith('image/')) {
            const reader = new FileReader();
            reader.onload = function(e) {
                const preview = document.getElementById('uploadPreview');
                preview.querySelector('img').src = e.target.result;
                preview.style.display = 'block';
            };
            reader.readAsDataURL(file);
        }
    });
}

// 画像挿入の確認
async function confirmInsertImage() {
    const activeTab = document.querySelector('#imageInsertModal .tab-pane.active').id;
    
    if (activeTab === 'uploadTab') {
        // アップロード処理
        const fileInput = document.getElementById('imageFile');
        const file = fileInput.files[0];
        const alt = document.getElementById('uploadAlt').value;
        
        if (!file) {
            alert('画像ファイルを選択してください');
            return;
        }
        
        const formData = new FormData();
        formData.append('image', file);
        
        try {
            const response = await fetch('../api/upload-image.php', {
                method: 'POST',
                body: formData
            });
            
            console.log('Upload response status:', response.status);
            const result = await response.json();
            console.log('Upload result:', result);
            
            if (result.success) {
                insertImageToEditor(result.url, alt || file.name);
                bootstrap.Modal.getInstance(document.getElementById('imageInsertModal')).hide();
            } else {
                alert('アップロードエラー: ' + result.error);
            }
        } catch (error) {
            alert('アップロード中にエラーが発生しました');
            console.error(error);
        }
    } else {
        // URL指定
        const url = document.getElementById('imageUrl').value;
        const alt = document.getElementById('urlAlt').value;
        
        if (!url) {
            alert('画像URLを入力してください');
            return;
        }
        
        insertImageToEditor(url, alt);
        bootstrap.Modal.getInstance(document.getElementById('imageInsertModal')).hide();
    }
}

// 現在のカーソル位置を保存
let savedSelection = null;

// 選択範囲を保存してから画像を挿入
function saveSelectionAndInsertImage(url, alt) {
    // 現在の選択範囲を保存
    const selection = window.getSelection();
    if (selection.rangeCount > 0) {
        savedSelection = selection.getRangeAt(0).cloneRange();
        console.log('Saved selection range before insert');
    }
    
    // 画像を挿入
    insertImageToEditor(url, alt);
}

// エディタに既存画像を挿入
function insertImageToEditor(url, alt) {
    console.log('insertImageToEditor called with:', url, alt);
    
    const editor = document.getElementById('editor');
    if (!editor) {
        console.error('Editor element not found');
        return;
    }
    
    // エディタにフォーカスを当てる
    editor.focus();
    
    // HTMLを挿入（HTMLエスケープを追加）
    const escapedUrl = url.replace(/"/g, '&quot;').replace(/'/g, '&#39;');
    const escapedAlt = alt.replace(/"/g, '&quot;').replace(/'/g, '&#39;').replace(/</g, '&lt;').replace(/>/g, '&gt;');
    
    const img = `<figure class="text-center my-4">
        <img src="${escapedUrl}" alt="${escapedAlt}" class="img-fluid rounded">
        <figcaption class="text-muted small mt-2">${escapedAlt}</figcaption>
    </figure>`;
    
    try {
        // 保存された選択範囲があれば復元
        if (savedSelection) {
            const selection = window.getSelection();
            selection.removeAllRanges();
            selection.addRange(savedSelection);
        }
        
        // insertHTMLを実行
        const result = document.execCommand('insertHTML', false, img);
        console.log('insertHTML result:', result);
        
        if (!result) {
            // 代替方法：選択範囲に直接挿入
            const selection = window.getSelection();
            if (selection.rangeCount > 0) {
                const range = selection.getRangeAt(0);
                range.deleteContents();
                
                const tempDiv = document.createElement('div');
                tempDiv.innerHTML = img;
                const fragment = document.createDocumentFragment();
                while (tempDiv.firstChild) {
                    fragment.appendChild(tempDiv.firstChild);
                }
                range.insertNode(fragment);
                
                // カーソルを画像の後に移動
                range.collapse(false);
                selection.removeAllRanges();
                selection.addRange(range);
            } else {
                // 選択範囲がない場合は最後に追加
                editor.innerHTML += img;
            }
        }
    } catch (error) {
        console.error('Error inserting image:', error);
        // エラー時は最後に追加
        editor.innerHTML += img;
    }
    
    // 選択範囲をクリア
    savedSelection = null;
    
    // 文字数を更新
    updateCharCount();
}

// HTML/ビジュアル切り替え
function toggleView() {
    const editor = document.getElementById('editor');
    const htmlEditor = document.getElementById('htmlEditor');
    const editorWrapper = document.getElementById('editorWrapper');
    
    if (isHtmlView) {
        editor.innerHTML = htmlEditor.value;
        editorWrapper.style.display = 'block';
        htmlEditor.style.display = 'none';
    } else {
        htmlEditor.value = editor.innerHTML;
        editorWrapper.style.display = 'none';
        htmlEditor.style.display = 'block';
        
        // HTMLエディタの高さをeditorWrapperと同じに設定
        const wrapperHeight = localStorage.getItem('editorHeight') || '700';
        htmlEditor.style.height = wrapperHeight + 'px';
    }
    
    isHtmlView = !isHtmlView;
}

// AIリライト
async function aiRewrite() {
    const selection = window.getSelection().toString();
    if (!selection) {
        alert('リライトしたいテキストを選択してください。');
        return;
    }
    
    if (confirm('選択したテキストをAIでリライトしますか？')) {
        // AI APIを呼び出してリライト
        showToast('AIリライト機能は準備中です', 'info');
    }
}

// AI改善
async function aiImprove() {
    showToast('AI文章改善機能は準備中です', 'info');
}

// AI拡張
async function aiExpand() {
    showToast('AI内容拡張機能は準備中です', 'info');
}

// AI要約
async function aiSummarize() {
    showToast('AI要約生成機能は準備中です', 'info');
}

// AI SEO最適化
async function aiSEO() {
    showToast('AI SEO最適化機能は準備中です', 'info');
}

// AI画像生成
async function aiGenerateImage() {
    showToast('AI画像追加生成機能は準備中です', 'info');
}

// プレビュー
function previewArticle() {
    const title = document.getElementById('title').value;
    const content = isHtmlView ? document.getElementById('htmlEditor').value : document.getElementById('editor').innerHTML;
    
    const previewHtml = `
        <article class="preview-article">
            <h1>${title}</h1>
            <div class="article-meta text-muted mb-4">
                <small>プレビュー生成日時: ${new Date().toLocaleString('ja-JP')}</small>
            </div>
            <div class="article-content">
                ${content}
            </div>
        </article>
    `;
    
    document.getElementById('previewContent').innerHTML = previewHtml;
    new bootstrap.Modal(document.getElementById('previewModal')).show();
}

// フォーム送信
document.addEventListener('DOMContentLoaded', function() {
    const editForm = document.getElementById('editForm');
    if (!editForm) {
        console.error('editForm not found');
        return;
    }
    
    editForm.addEventListener('submit', async function(e) {
        e.preventDefault();
    
    const content = isHtmlView ? document.getElementById('htmlEditor').value : document.getElementById('editor').innerHTML;
    
    // カテゴリの取得（ドロップダウンまたはカスタム入力）
    const categorySelect = document.getElementById('category').value;
    const customCategoryEl = document.getElementById('custom_category');
    const customCategory = customCategoryEl ? customCategoryEl.value.trim() : '';
    const category = customCategory || categorySelect || 'その他';
    
    const data = {
        action: 'update',
        id: document.getElementById('articleId').value,
        title: document.getElementById('title').value,
        keywords: document.getElementById('keywords').value,
        tags: document.getElementById('tags').value,
        category: category,
        content: content,
        images: currentImages,
        seo: {
            metaTitle: document.getElementById('metaTitle').value,
            metaDescription: document.getElementById('metaDescription').value,
            slug: document.getElementById('slug').value
        }
    };
    
    try {
        const response = await fetch('../api/article-service.php', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json'
            },
            body: JSON.stringify(data)
        });
        
        const result = await response.json();
        
        if (result.success) {
            showToast('記事を保存しました', 'success');
        } else {
            showToast('保存に失敗しました: ' + result.error, 'danger');
        }
    } catch (error) {
        showToast('エラーが発生しました: ' + error.message, 'danger');
    }
    });
});

// 保存して履歴に戻る
function saveAndReturn() {
    const form = document.getElementById('editForm');
    const formData = new FormData(form);
    
    // 保存処理を実行してから履歴ページに戻る
    const submitEvent = new Event('submit', { cancelable: true });
    form.dispatchEvent(submitEvent);
    
    // 保存成功を待ってからリダイレクト
    setTimeout(() => {
        window.location.href = '?page=history';
    }, 1000);
}

// 保存して公開
function saveAndPublish() {
    // WordPress連携など（実装準備）
    showToast('公開機能は準備中です', 'info');
}

// 画像削除
function removeImage(index) {
    if (confirm('この画像を削除しますか？')) {
        currentImages.splice(index, 1);
        location.reload(); // 簡易的な更新
    }
}

// トースト通知
function showToast(message, type = 'info') {
    // Bootstrapが読み込まれているか確認
    if (typeof bootstrap === 'undefined' || !bootstrap.Toast) {
        // フォールバック: アラートを表示
        alert(message);
        return;
    }
    
    const toastHtml = `
        <div class="toast align-items-center text-white bg-${type} border-0" role="alert">
            <div class="d-flex">
                <div class="toast-body">${message}</div>
                <button type="button" class="btn-close btn-close-white me-2 m-auto" data-bs-dismiss="toast"></button>
            </div>
        </div>
    `;
    
    let container = document.querySelector('.toast-container');
    if (!container) {
        container = document.createElement('div');
        container.className = 'toast-container position-fixed top-0 end-0 p-3';
        container.style.zIndex = '9999';
        document.body.appendChild(container);
    }
    
    container.insertAdjacentHTML('beforeend', toastHtml);
    const toastEl = container.lastElementChild;
    const toast = new bootstrap.Toast(toastEl);
    toast.show();
}

// エディタの入力監視
document.addEventListener('DOMContentLoaded', function() {
    const editor = document.getElementById('editor');
    if (editor) {
        editor.addEventListener('input', updateCharCount);
    }
});

// エディタのリサイズ設定
function setupEditorResize() {
    const editorWrapper = document.getElementById('editorWrapper');
    const htmlEditor = document.getElementById('htmlEditor');
    
    // 保存された高さを復元
    const savedHeight = localStorage.getItem('editorHeight');
    if (savedHeight) {
        editorWrapper.style.height = savedHeight + 'px';
        htmlEditor.style.height = savedHeight + 'px';
    }
    
    // リサイズイベントの監視
    const resizeObserver = new ResizeObserver(entries => {
        for (let entry of entries) {
            const height = entry.target.offsetHeight;
            localStorage.setItem('editorHeight', height);
            
            // HTMLエディタも同じ高さに
            if (entry.target.id === 'editorWrapper') {
                htmlEditor.style.height = height + 'px';
            }
        }
    });
    
    resizeObserver.observe(editorWrapper);
}

// サイト設定データ
const siteConfigs = <?php echo json_encode($siteConfigs ?? []); ?>;

// DMM画像をローカライズ
async function localizeDMMImages() {
    console.log('localizeDMMImages called');
    const articleId = document.getElementById('articleId').value;
    const dmmData = <?php echo json_encode($article['metadata']['dmm_data'] ?? []); ?>;
    
    console.log('DMM data:', dmmData);
    
    if (!dmmData.sample_images || dmmData.sample_images.length === 0) {
        console.log('No DMM sample images found');
        return;
    }
    
    // すべてのDMM画像URLを収集
    const dmmImages = [];
    if (dmmData.product_image) {
        dmmImages.push(dmmData.product_image);
    }
    dmmData.sample_images.forEach(img => {
        if (img) dmmImages.push(img);
    });
    
    console.log('Sending DMM images to download:', dmmImages);
    
    try {
        const response = await fetch('../api/download-dmm-images.php', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json'
            },
            body: JSON.stringify({
                article_id: articleId,
                images: dmmImages
            })
        });
        
        console.log('Download response status:', response.status);
        const result = await response.json();
        console.log('Download result:', result);
        
        if (result.success && result.images) {
            // ローカルURLで画像を更新
            result.images.forEach(img => {
                // エディタ内の画像URLを更新
                const editor = document.getElementById('editor');
                if (editor) {
                    editor.innerHTML = editor.innerHTML.replace(
                        new RegExp(escapeRegExp(img.original_url), 'g'),
                        img.local_url
                    );
                }
                
                // currentImagesも更新
                currentImages.forEach(currentImg => {
                    if (currentImg.url === img.original_url) {
                        currentImg.url = img.local_url;
                        currentImg.local_url = img.local_url;
                        currentImg.is_dmm_localized = true;
                    }
                });
            });
            
            console.log('DMM画像をローカライズしました:', result.downloaded + '枚');
        }
    } catch (error) {
        console.error('DMM画像のローカライズエラー:', error);
    }
}

// 正規表現エスケープ用ヘルパー関数
function escapeRegExp(string) {
    return string.replace(/[.*+?^${}()|[\]\\]/g, '\\$&');
}

// デザインモード切り替え
async function applyDesignMode(mode) {
    const editorWrapper = document.getElementById('editorWrapper');
    const editor = document.getElementById('editor');
    
    // 既存のデザインスタイルを削除
    const existingStyle = document.getElementById('siteDesignStyle');
    if (existingStyle) {
        existingStyle.remove();
    }
    
    if (mode === 'none') {
        // デフォルトスタイルに戻す
        editorWrapper.className = 'editor-wrapper';
        editor.className = 'form-control editor-content';
        return;
    }
    
    // サイト設定を取得
    const siteConfig = siteConfigs[mode];
    if (!siteConfig) return;
    
    // デザイン設定を適用
    const designSettings = siteConfig.design_settings || {};
    
    // スタイルタグを生成
    const styleTag = document.createElement('style');
    styleTag.id = 'siteDesignStyle';
    
    let css = `
        /* エディタ内デザインプレビュー */
        .editor-wrapper {
            background: ${designSettings.backgrounds?.page_bg_color || '#ffffff'};
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        
        .editor-content {
            background: ${designSettings.backgrounds?.article_bg_color || '#ffffff'} !important;
            color: ${designSettings.theme_colors?.text || '#333333'} !important;
            font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, "Helvetica Neue", Arial, sans-serif;
            line-height: 1.8;
            padding: 30px !important;
        }
        
        .editor-content a {
            color: ${designSettings.theme_colors?.link || '#007bff'} !important;
            text-decoration: none;
        }
        
        .editor-content a:hover {
            color: ${designSettings.theme_colors?.link_hover || '#0056b3'} !important;
            text-decoration: underline;
        }
    `;
    
    // 見出しスタイル
    if (designSettings.heading_styles) {
        // H1スタイル
        if (designSettings.heading_styles.h1_style !== 'none') {
            css += generateHeadingStyle('h1', 
                designSettings.heading_styles.h1_style, 
                designSettings.heading_styles.h1_color
            );
        }
        
        // H2スタイル
        if (designSettings.heading_styles.h2_style !== 'none') {
            css += generateHeadingStyle('h2', 
                designSettings.heading_styles.h2_style, 
                designSettings.heading_styles.h2_color
            );
        }
        
        // H3スタイル
        if (designSettings.heading_styles.h3_style !== 'none') {
            css += generateHeadingStyle('h3', 
                designSettings.heading_styles.h3_style, 
                designSettings.heading_styles.h3_color
            );
        }
    }
    
    // テーマカラーをCSS変数として設定
    if (designSettings.theme_colors) {
        css += `
            .editor-content {
                --theme-primary: ${designSettings.theme_colors.primary || '#007bff'};
                --theme-secondary: ${designSettings.theme_colors.secondary || '#6c757d'};
                --theme-accent: ${designSettings.theme_colors.accent || '#28a745'};
            }
        `;
    }
    
    styleTag.textContent = css;
    document.head.appendChild(styleTag);
    
    // ラッパーにサイト識別クラスを追加
    editorWrapper.className = `editor-wrapper site-design-${mode}`;
    
    // 通知
    showToast(`${siteConfig.display_name}のデザインを適用しました`, 'success');
}

// 見出しスタイルを生成
function generateHeadingStyle(tag, style, color) {
    let css = `\n.editor-content ${tag} {\n`;
    
    switch(style) {
        case 'filled':
            css += `
                background: ${color};
                color: #ffffff;
                padding: 12px 20px;
                border-radius: 4px;
                margin: 1.5em 0 1em;
            `;
            break;
            
        case 'underline':
            css += `
                color: ${color};
                border-bottom: 3px solid ${color};
                padding-bottom: 8px;
                margin: 1.5em 0 1em;
            `;
            break;
            
        case 'checkmark':
            css += `
                color: ${color};
                padding-left: 35px;
                position: relative;
                margin: 1.5em 0 1em;
            }
            .editor-content ${tag}::before {
                content: '✓';
                position: absolute;
                left: 0;
                font-weight: bold;
                font-size: 1.2em;
                color: ${color};
            `;
            break;
            
        default:
            css += `
                color: ${color};
                margin: 1.5em 0 1em;
            `;
    }
    
    css += '}\n';
    return css;
}

// 新しいプレビュー機能（サイトデザイン付き）
async function previewWithSiteDesign(configId, siteName) {
    const title = document.getElementById('title').value;
    const content = isHtmlView ? document.getElementById('htmlEditor').value : document.getElementById('editor').innerHTML;
    
    // APIでプレビューHTMLを生成
    try {
        const response = await fetch('../api/generate-preview.php', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json'
            },
            body: JSON.stringify({
                config_id: configId,
                title: title,
                content: content,
                category: document.getElementById('category').value || document.getElementById('custom_category').value || 'その他',
                created_at: '<?php echo $article['created_at']; ?>'
            })
        });
        
        const result = await response.json();
        
        if (result.success) {
            // 新しいウィンドウでプレビューを開く
            const previewWindow = window.open('', '_blank');
            previewWindow.document.write(result.html);
            previewWindow.document.close();
        } else {
            showToast('プレビュー生成エラー: ' + result.error, 'danger');
        }
    } catch (error) {
        showToast('プレビューの生成中にエラーが発生しました', 'danger');
        console.error(error);
    }
}
</script>

<style>
/* ページ全体のレイアウト調整 */
.page-header {
    margin-bottom: 1rem !important;
}

/* Bootstrapのマージンを最適化 */
#editForm > div.mb-4 {
    margin-bottom: 0.75rem !important;
}

/* カテゴリー選択エリアの下の余白を完全に削除 */
#editForm > div.mb-4:has(#category) {
    margin-bottom: 0 !important;
}

/* カテゴリー選択の次の要素（エディタセクション）の上余白を削除 */
#editForm > div.mb-4:has(#category) + div {
    margin-top: 0 !important;
    padding-top: 0 !important;
}

/* ラベルとフォーム要素の間隔 */
.form-label {
    margin-bottom: 0.25rem !important;
    font-size: 0.875rem;
    font-weight: 600;
}

.form-text {
    margin-top: 0.125rem !important;
    margin-bottom: 0 !important;
    font-size: 0.75rem;
}

/* 記事内容のラベルとツールバー間の余白を削除 */
#editForm > div.mb-4:has(.editor-toolbar) > div:first-child {
    margin-bottom: 0 !important;
}

/* エディタツールバー */
.editor-toolbar {
    background-color: #f8f9fa;
    border: 1px solid #dee2e6;
    border-bottom: none;
    padding: 0.5rem;
    border-radius: 0.375rem 0.375rem 0 0;
    margin-bottom: 0 !important;
    margin-top: 0 !important;
}

/* mb-2クラスを持つエディタツールバーの余白を0に */
.editor-toolbar.mb-2 {
    margin-bottom: 0 !important;
}

/* エディタラッパー */
.editor-wrapper {
    position: relative;
    margin-bottom: 0 !important;
    margin-top: 0 !important;
    resize: vertical; /* ラッパー全体をリサイズ可能に */
    overflow: auto;
    min-height: 600px;
    height: 700px;
    border: 1px solid #dee2e6;
    border-radius: 0 0 0.375rem 0.375rem;
}

/* コンテンツエディタのコンテナ - 上の余白を削除 */
#editForm > div.mb-4:has(#editorWrapper) {
    margin-bottom: 1rem !important;
    margin-top: 0 !important;
}

/* mt-2クラスの余白を削除 */
#editForm > div.mt-2 {
    margin-top: 0 !important;
}

/* 記事内容ラベルとデザインモード選択の間隔 */
#editForm > div.mb-4:has(#editorWrapper) .mb-2 {
    margin-bottom: 0 !important;
}

/* エディタ本体 */
#editor,
.editor-content {
    background: #fff;
    border: none; /* ラッパーに枠線があるので削除 */
    border-radius: 0;
    padding: 1.25rem;
    min-height: 100%;
    height: 100%;
    max-height: none !important;
    overflow-y: auto;
    font-size: 14px;
    line-height: 1.6;
    width: 100%;
    position: relative;
}

/* リサイズハンドルのスタイル */
.editor-wrapper:after {
    content: '';
    position: absolute;
    bottom: 0;
    right: 0;
    width: 20px;
    height: 20px;
    cursor: ns-resize;
    background: linear-gradient(135deg, transparent 50%, #666 50%);
    border-radius: 0 0 0.375rem 0;
    pointer-events: none; /* マウスイベントは親要素で処理 */
}

/* HTMLエディタのスタイル */
.editor-html {
    min-height: 600px;
    height: 700px;
    font-family: 'Consolas', 'Monaco', 'Courier New', monospace;
    resize: vertical;
    border: 1px solid #dee2e6;
    border-radius: 0.375rem;
    padding: 1rem;
    width: 100%;
    overflow-y: auto;
}

#editor:focus,
.editor-content:focus {
    outline: none;
    border-color: #86b7fe;
    box-shadow: 0 0 0 0.25rem rgba(13, 110, 253, .25);
}

/* 画像の自動調整 */
#editor img,
.editor-content img {
    max-width: 100% !important;
    height: auto !important;
    display: block;
    margin: 1rem auto;
}

#editor figure {
    max-width: 100%;
    margin: 1rem 0;
}

#editor figcaption {
    text-align: center;
    font-size: 0.9em;
    color: #6c757d;
    margin-top: 0.5rem;
}

/* プレビュー記事のスタイル */
.preview-article {
    max-width: 800px;
    margin: 0 auto;
    padding: 2rem;
}

.preview-article h1 {
    font-size: 2rem;
    margin-bottom: 1rem;
}

.preview-article h2 {
    font-size: 1.75rem;
    margin-top: 1.5rem;
    margin-bottom: 0.75rem;
}

.preview-article h3 {
    font-size: 1.5rem;
    margin-top: 1.25rem;
    margin-bottom: 0.5rem;
}

.preview-article img {
    max-width: 100%;
    height: auto;
}

/* カードの余白調整 */
.card {
    margin-bottom: 1rem !important;
}

/* SEO設定カード */
.card.mb-4 {
    margin-bottom: 1rem !important;
}

/* textareaの高さ */
textarea.form-control {
    min-height: 80px;
    max-height: 200px;
    resize: none; /* リサイズ無効化（HTMLエディタ以外） */
}

/* HTMLエディタ */
#htmlEditor {
    min-height: 600px;
    height: 700px;
    max-height: none;
    font-family: 'Consolas', 'Monaco', 'Courier New', monospace;
    resize: vertical; /* ユーザーが縦方向にリサイズ可能 */
}

/* レスポンシブ対応 */
@media (min-width: 1200px) {
    .col-lg-9 {
        flex: 0 0 70%;
        max-width: 70%;
    }
    .col-lg-3 {
        flex: 0 0 30%;
        max-width: 30%;
    }
}

/* モバイル対応 */
@media (max-width: 991px) {
    .col-lg-9,
    .col-lg-3 {
        flex: 0 0 100%;
        max-width: 100%;
    }
    
    #editor,
    .editor-content {
        font-size: 16px;
    }
}
</style>

<script>
// 現在の画像リスト
let currentImages = <?php echo json_encode($article['images'] ?? []); ?>;
const articleId = '<?php echo $editId; ?>';

// DMM画像のローカル化
document.addEventListener('DOMContentLoaded', function() {
    // DMM商品サンプル画像を確認
    <?php if (isset($article['metadata']['type']) && $article['metadata']['type'] === 'dmm' && 
              isset($article['metadata']['dmm_data']['sample_images']) && 
              !empty($article['metadata']['dmm_data']['sample_images'])): ?>
    
    const dmmImages = <?php echo json_encode($article['metadata']['dmm_data']['sample_images']); ?>;
    
    // 各DMM画像をチェックしてローカルにダウンロード
    dmmImages.forEach((imageUrl, index) => {
        const imgElement = document.querySelector(`img[src="${imageUrl}"]`);
        if (imgElement && imageUrl.startsWith('http')) {
            // DMM画像をローカルにダウンロード
            fetch('/seitekisitebilder/api/download-dmm-image.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                },
                body: JSON.stringify({
                    url: imageUrl,
                    article_id: articleId
                })
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    // 画像URLを更新
                    imgElement.src = data.url;
                    
                    // ボタンのonclick属性も更新
                    const insertButton = imgElement.closest('.card').querySelector('button[onclick*="saveSelectionAndInsertImage"]');
                    if (insertButton) {
                        insertButton.setAttribute('onclick', `saveSelectionAndInsertImage('${data.url}', '${imgElement.alt}')`);
                    }
                }
            })
            .catch(error => {
                console.error('DMM画像のダウンロードエラー:', error);
            });
        }
    });
    
    <?php endif; ?>
});

// 画像ダウンロード関数
window.downloadImage = function(imageUrl, filename) {
    // 画像をダウンロード
    fetch(imageUrl)
        .then(response => response.blob())
        .then(blob => {
            const url = window.URL.createObjectURL(blob);
            const a = document.createElement('a');
            a.style.display = 'none';
            a.href = url;
            a.download = filename;
            document.body.appendChild(a);
            a.click();
            window.URL.revokeObjectURL(url);
            document.body.removeChild(a);
        })
        .catch(error => {
            console.error('画像ダウンロードエラー:', error);
            alert('画像のダウンロードに失敗しました');
        });
};

// すべての画像をダウンロード
window.downloadAllImages = function(images, articleTitle) {
    if (!images || images.length === 0) {
        alert('ダウンロードする画像がありません');
        return;
    }
    
    // 画像を順番にダウンロード
    images.forEach((image, index) => {
        setTimeout(() => {
            const filename = `${articleTitle}_${index + 1}_${image.alt || 'image'}.jpg`;
            window.downloadImage(image.url, filename);
        }, index * 500); // 0.5秒間隔でダウンロード
    });
};

// 選択範囲を保存して画像を挿入
let savedSelection = null;

window.saveSelectionAndInsertImage = function(imageUrl, altText) {
    const editor = document.getElementById('editor');
    editor.focus();
    
    // 画像タグを作成
    const img = document.createElement('img');
    img.src = imageUrl;
    img.alt = altText || '';
    img.style.maxWidth = '100%';
    img.style.height = 'auto';
    
    // 選択範囲に画像を挿入
    const selection = window.getSelection();
    if (selection.rangeCount > 0) {
        const range = selection.getRangeAt(0);
        range.deleteContents();
        range.insertNode(img);
        
        // カーソルを画像の後に移動
        range.setStartAfter(img);
        range.collapse(true);
        selection.removeAllRanges();
        selection.addRange(range);
    } else {
        // 選択範囲がない場合は末尾に追加
        editor.appendChild(img);
    }
    
    // 文字数を更新
    updateCharCount();
};

// 重複した関数定義を削除（上部で定義済み）
    
    // DMMサンプル画像のデータを取得
    <?php if (isset($article['metadata']['dmm_data']['sample_images'])): ?>
    const dmmData = <?php echo json_encode($article['metadata']['dmm_data']['sample_images'] ?? []); ?>;
    <?php else: ?>
    const dmmData = [];
    <?php endif; ?>
    
    if (!dmmData || dmmData.length === 0) {
        alert('挿入する画像がありません');
        return;
    }
    
    // エディタにフォーカス
    editor.focus();
    
    // 現在のカーソル位置を保存
    const selection = window.getSelection();
    let range;
    if (selection.rangeCount > 0) {
        range = selection.getRangeAt(0);
    } else {
        // カーソル位置がない場合は末尾に設定
        range = document.createRange();
        range.selectNodeContents(editor);
        range.collapse(false);
    }
    
    // 画像を一つずつ挿入
    dmmData.forEach((imageUrl, index) => {
        const altText = `DMM商品サンプル画像${index + 1}`;
        
        // HTMLを作成
        const figureHtml = `<figure class="text-center my-4">
            <img src="${imageUrl.replace(/"/g, '&quot;').replace(/'/g, '&#39;')}" 
                 alt="${altText}" 
                 class="img-fluid rounded">
            <figcaption class="text-muted small mt-2">${altText}</figcaption>
        </figure>`;
        
        // 一時的なdivに入れてDOMノードに変換
        const tempDiv = document.createElement('div');
        tempDiv.innerHTML = figureHtml;
        
        // rangeに挿入
        while (tempDiv.firstChild) {
            range.insertNode(tempDiv.firstChild);
            // 次の挿入位置を画像の後に設定
            range.collapse(false);
        }
        
        // 画像間に改行を追加（最後の画像以外）
        if (index < dmmData.length - 1) {
            const br = document.createElement('br');
            range.insertNode(br);
            range.setStartAfter(br);
            range.collapse(true);
        }
    });
    
    // カーソルを最後の画像の後に移動
    selection.removeAllRanges();
    selection.addRange(range);
    
    // 文字数を更新
    updateCharCount();
    
    showToast(`${dmmData.length}枚の画像を挿入しました`, 'success');
}

// URLスラッグ生成
function generateSlugFromTitle() {
    const title = document.getElementById('title').value;
    if (!title) {
        alert('タイトルを入力してください');
        return;
    }
    
    // タイトルからスラッグを生成（日本語を除外）
    let slug = title.trim()
        // 日本語文字を除去
        .replace(/[\u3040-\u309f\u30a0-\u30ff\u4e00-\u9faf\u3400-\u4dbf]/g, '')
        // 特殊文字を削除（英数字、スペース、ハイフン、アンダースコアのみ残す）
        .replace(/[^\w\s\-_]/g, '')
        // 連続するスペースを1つのハイフンに
        .replace(/\s+/g, '-')
        // 連続するハイフンを1つに
        .replace(/-+/g, '-')
        // 先頭と末尾のハイフンを削除
        .replace(/^-|-$/g, '')
        // 小文字に変換
        .toLowerCase();
    
    // 空の場合はランダムな文字列を生成
    if (!slug) {
        slug = 'article-' + Date.now();
    }
    
    document.getElementById('slug').value = slug;
}

// カテゴリー選択の処理
document.getElementById('category').addEventListener('change', function() {
    const customCategoryInput = document.getElementById('custom_category');
    if (this.value === 'add-new-category') {
        // カスタムカテゴリー入力を表示してフォーカス
        customCategoryInput.style.display = 'block';
        customCategoryInput.focus();
        this.value = ''; // プルダウンをリセット
    } else {
        // 既存カテゴリーが選択された場合は入力フィールドをクリア
        customCategoryInput.value = '';
        customCategoryInput.style.display = 'none';
    }
});

// ページ読み込み時のカテゴリー表示処理
document.addEventListener('DOMContentLoaded', function() {
    const categorySelect = document.getElementById('category');
    const customCategoryInput = document.getElementById('custom_category');
    
    // カスタムカテゴリーが入力されている場合は表示
    if (customCategoryInput.value) {
        customCategoryInput.style.display = 'block';
    } else {
        customCategoryInput.style.display = 'none';
    }
});

// グローバル関数として登録
window.generateSlugFromTitle = generateSlugFromTitle;
window.generateMetaTitle = generateMetaTitle;
window.generateMetaDescription = generateMetaDescription;
</script>

<?php require_once __DIR__ . "/../layout/footer.php"; ?>
