<?php
// 設定ファイルが読み込まれているか確認
if (!isset($config)) {
    // 直接アクセスの場合はリダイレクト
    header('Location: ../index.php?page=duga');
    exit;
}
?>

<div class="page-content" style="min-height: 100vh; padding-bottom: 100px;">
    <div class="page-header mb-4">
        <h1><i class="bi bi-film"></i> DUGA商品記事生成</h1>
        <p class="text-muted">DUGAの商品情報を取得し、AIで記事を自動生成します</p>
    </div>

    <!-- APIキー設定の確認 -->
    <div id="apiKeyAlert" class="alert alert-warning">
        <i class="bi bi-exclamation-triangle"></i> 
        DUGA API設定を確認中...
        <?php 
        echo "app_id: " . (!empty($config['duga']['app_id']) ? '設定済み' : '未設定') . "<br>";
        echo "agent_id: " . (!empty($config['duga']['agent_id']) ? '設定済み' : '未設定') . "<br>";
        echo "banner_id: " . (!empty($config['duga']['banner_id']) ? '設定済み' : '未設定');
        ?>
    </div>

    <!-- Step 1: 商品検索 -->
    <div class="card mb-4">
        <div class="card-header bg-primary text-white">
            <h5 class="mb-0"><i class="bi bi-search"></i> Step 1: 商品検索</h5>
        </div>
        <div class="card-body">
            <form id="searchForm">
                <div class="row">
                    <div class="col-md-6">
                        <label for="searchKeyword" class="form-label">検索キーワード</label>
                        <input type="text" class="form-control" id="searchKeyword" placeholder="商品名、女優名、メーカー名など">
                    </div>
                    <div class="col-md-6">
                        <button type="submit" class="btn btn-primary btn-lg mt-4">
                            <i class="bi bi-search"></i> 商品を検索
                        </button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
document.getElementById('searchForm').addEventListener('submit', function(e) {
    e.preventDefault();
    alert('検索機能のテスト - キーワード: ' + document.getElementById('searchKeyword').value);
});
</script>